<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installation Wizard - {{ config('app.name') }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
    </style>
</head>
<body class="bg-gray-50 min-h-screen flex items-center justify-center p-4">
    <div class="w-full max-w-4xl bg-white rounded-2xl shadow-xl overflow-hidden flex flex-col md:flex-row">
        <!-- Sidebar -->
        <div class="md:w-1/3 bg-indigo-600 p-8 text-white flex flex-col justify-between">
            <div>
                <h1 class="text-2xl font-bold mb-2">Installation</h1>
                <p class="text-indigo-200 text-sm">Set up your application in minutes.</p>
                
                <div class="mt-8 space-y-4">
                    <div class="flex items-center gap-3 opacity-100">
                        <div class="w-8 h-8 rounded-full bg-white text-indigo-600 flex items-center justify-center font-bold">1</div>
                        <span>Configuration</span>
                    </div>
                    <div class="flex items-center gap-3 opacity-50">
                        <div class="w-8 h-8 rounded-full border-2 border-white flex items-center justify-center font-bold">2</div>
                        <span>Complete</span>
                    </div>
                </div>
            </div>
            <div class="text-xs text-indigo-300 mt-8">
                &copy; {{ date('Y') }} {{ config('app.name') }}
            </div>
        </div>

        <!-- Content -->
        <div class="md:w-2/3 p-8 md:p-12">
            @if ($errors->any())
                <div class="mb-6 bg-red-50 border-l-4 border-red-500 p-4">
                    <div class="flex">
                        <div class="flex-shrink-0">
                            <svg class="h-5 w-5 text-red-400" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                            </svg>
                        </div>
                        <div class="ml-3">
                            <h3 class="text-sm font-medium text-red-800">Installation Failed</h3>
                            <div class="mt-2 text-sm text-red-700">
                                <ul class="list-disc pl-5 space-y-1">
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            @yield('content')
        </div>
    </div>
</body>
</html>
